# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 4
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR4_strategy.txt
# LLM Suggested Fallback: Not Provided

def radiant_harmony(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"
    
    # Detect if opponent is likely to mirror or alternate
    is_mirror = "mirror" in opponent_program_code or "opp_history[-1]" in opponent_program_code
    is_alternator = "alternator" in opponent_program_code or "len(my_history) % 2" in opponent_program_code
    
    # React to opponent's defection streaks
    if len(opp_history) >= 2 and all(m == "D" for m in opp_history[-2:]):
        return "D"
    
    # Introduce controlled unpredictability
    if is_mirror or is_alternator:
        if random.random() < 0.2:
            return "D"
    
    # Maintain cooperation but test occasionally
    if len(my_history) % 4 == 0 and all(m == "C" for m in opp_history[-3:]):
        return "D"
    
    # Default to Tit-for-Tat with occasional variation
    if opp_history:
        return opp_history[-1]
    
    return "C"